/*
 * Decompiled with CFR 0.152.
 */
package sufftracker;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import sufftracker.ContentFrame;
import sufftracker.ContentPanel;
import sufftracker.Contestant;

public class ContestantPanel
extends ContentPanel {
    private JLabel AmountLabel;
    private JLabel DateLabel;
    private JPanel DrinkProgrssBar;
    private JLabel NameLabel;
    private JButton OneMore;
    private JProgressBar ProgressBarDrunk;
    private JLabel jLabel2;

    public ContestantPanel(Contestant s, ContentFrame parent) {
        this.initComponents();
        this.setSize(this.getPreferredSize());
        this.parent = parent;
        this.contestant = s;
        this.nameChanged();
        this.amountChanged();
        this.startThread();
    }

    @Override
    public void step() {
        super.step();
        int sec = (int)((System.currentTimeMillis() - this.contestant.latest.timestamp) / 1000L);
        int min = sec / 60;
        sec -= min * 60;
        int hours = min / 60;
        this.DateLabel.setText("Letzter Alk " + (hours == 0 ? "" : hours + " Stunde" + (hours == 1 ? "" : "n") + " und ") + (min -= hours * 60) + ":" + (sec < 10 ? "0" : "") + sec + " Minuten her");
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.OneMore = new JButton();
        this.AmountLabel = new JLabel();
        this.NameLabel = new JLabel();
        this.DateLabel = new JLabel();
        this.DrinkProgrssBar = new JPanel();
        this.ProgressBarDrunk = new JProgressBar();
        this.setBackground(new Color(204, 204, 204));
        this.jLabel2.setFont(new Font("Cambria", 0, 14));
        this.jLabel2.setText("Menge:");
        this.OneMore.setFont(new Font("Cambria", 0, 14));
        this.OneMore.setText("Noch einer!");
        this.OneMore.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ContestantPanel.this.OneMoreActionPerformed(evt);
            }
        });
        this.AmountLabel.setFont(new Font("Cambria", 1, 14));
        this.AmountLabel.setText("999");
        this.NameLabel.setFont(new Font("Cambria", 1, 18));
        this.NameLabel.setText("Person ABC");
        this.DateLabel.setFont(new Font("Cambria", 2, 14));
        this.DateLabel.setHorizontalAlignment(4);
        this.DateLabel.setText("Letzter Alk 24 Stunden her");
        this.ProgressBarDrunk.setValue(30);
        GroupLayout DrinkProgrssBarLayout = new GroupLayout(this.DrinkProgrssBar);
        this.DrinkProgrssBar.setLayout(DrinkProgrssBarLayout);
        DrinkProgrssBarLayout.setHorizontalGroup(DrinkProgrssBarLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(DrinkProgrssBarLayout.createSequentialGroup().addContainerGap().addComponent(this.ProgressBarDrunk, -1, -1, Short.MAX_VALUE).addContainerGap()));
        DrinkProgrssBarLayout.setVerticalGroup(DrinkProgrssBarLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, DrinkProgrssBarLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.ProgressBarDrunk, -2, -1, -2).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.DateLabel, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.DrinkProgrssBar, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.AmountLabel, -2, 34, -2).addGap(75, 75, 75).addComponent(this.OneMore)).addComponent(this.NameLabel, GroupLayout.Alignment.LEADING, -2, 131, -2)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.NameLabel).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.AmountLabel)).addGap(13, 13, 13)).addComponent(this.OneMore, -1, -1, Short.MAX_VALUE)).addGap(0, 6, Short.MAX_VALUE).addComponent(this.DateLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.DrinkProgrssBar, -2, -1, -2).addContainerGap()));
    }

    private void OneMoreActionPerformed(ActionEvent evt) {
        this.plusOne();
        this.amountChanged();
    }

    @Override
    protected void plusOne() {
        this.contestant.plusOne();
    }

    @Override
    public void setCurrentMax(int m) {
        double perc;
        double d = perc = m > 0 ? (double)this.contestant.latest.amount / (double)m : 0.0;
        if (perc < 0.5) {
            this.DrinkProgrssBar.setBackground(new Color(255, (int)(perc * 2.0 * 255.0), 0));
        } else {
            this.DrinkProgrssBar.setBackground(new Color((int)(255.0 * (2.0 - perc * 2.0)), 255, 0));
        }
        this.ProgressBarDrunk.setValue((int)(perc * 100.0));
    }

    @Override
    public void amountChanged() {
        this.AmountLabel.setText(String.valueOf(this.contestant.latest.amount));
    }

    @Override
    public void nameChanged() {
        this.NameLabel.setText(this.contestant.latest.person);
    }
}

